package eu.europa.ec.simpl.data1.common.adapter.connector.model.contract;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;

public enum ConstraintOperator {
    EQ("equal"),
    NEQ("not equal"),

    GT("greater than"),

    GTEQ("greater than or equal to"),

    LT("less than"),

    LTEQ("less than or equal to"),

    ISPARTOF("isPartOf"),

    ISALLOF("isAllOf"),

    ISANYOF("isAnyOf"),

    ISNONEOF("isNoneOf"),

    IN("in"),
    LIKE("like");

    private String value;

    ConstraintOperator(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    @JsonCreator
    public static ConstraintOperator get(String key) {
        return Arrays.stream(ConstraintOperator.values())
                .filter(exampleEnum -> exampleEnum.toString().equalsIgnoreCase(key))
                .findAny()
                .orElseThrow(() -> new IllegalArgumentException("Invalid ConstraintOperator: " + key));
    }
}
