package eu.europa.ec.simpl.data1.common.adapter.connector.model.transfer;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DataDestination {

    private String type;

    private String region;

    private String consumerEmail;

    private String storage;

    private String bucketName;

    private String objectName;

    private String path;

    private String accessKey;

    private String secretKey;

    private String keyName;
}
