package eu.europa.ec.simpl.data1.common.tier2client.feign;

import eu.europa.ec.simpl.client.core.AuthenticationProviderConfig;
import eu.europa.ec.simpl.client.core.suppliers.AuthenticationProviderConfigSupplier;
import eu.europa.ec.simpl.client.core.suppliers.AuthorizationHeaderSupplier;
import eu.europa.ec.simpl.client.okhttp.OkHttpSimplClient;
import eu.europa.ec.simpl.data1.common.util.AuthBearerUtil;
import feign.Feign;
import feign.Logger;
import java.net.URI;
import okhttp3.OkHttpClient;

public final class FeignSupport {

    private FeignSupport() {}

    public static <T> T buildClient(
            OkHttpSimplClient simplClient,
            Class<T> clientType,
            String authenticationProviderServiceUrl,
            String bearerToken,
            String targetUrl,
            Logger.Level loggerLevel) {
        AuthenticationProviderConfigSupplier authenticationProviderConfigSupplier =
                () -> new AuthenticationProviderConfig(URI.create(authenticationProviderServiceUrl));
        AuthorizationHeaderSupplier authorizationHeaderSupplier = () -> AuthBearerUtil.toBearerString(bearerToken);
        return buildClient(
                simplClient,
                clientType,
                authenticationProviderConfigSupplier,
                authorizationHeaderSupplier,
                targetUrl,
                loggerLevel);
    }

    public static <T> T buildClient(
            OkHttpSimplClient simplClient,
            Class<T> clientType,
            AuthenticationProviderConfigSupplier authenticationProviderConfigSupplier,
            AuthorizationHeaderSupplier authorizationHeaderSupplier,
            String targetUrl,
            Logger.Level loggerLevel) {
        eu.europa.ec.simpl.client.core.SimplClient.Builder<OkHttpClient.Builder> simplClientBuilder =
                simplClient.builder();
        OkHttpClient.Builder builder = simplClientBuilder
                .setAuthenticationProviderConfigSupplier(authenticationProviderConfigSupplier)

                // bearer token to be sent to the catalogue
                .setAuthorizationHeaderSupplier(authorizationHeaderSupplier)
                .build();

        OkHttpClient okHttpClient = builder.build();

        return Feign.builder()
                .client(new feign.okhttp.OkHttpClient(okHttpClient))
                .logLevel(loggerLevel == null ? Logger.Level.NONE : loggerLevel)
                .target(clientType, targetUrl);
    }
}
