/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.config.feign;

import feign.Logger;
import feign.Request;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FeignClientDefaultConfig {
    private final Logger.Level loggerLevel;
    private final int connectTimeout;
    private final int readTimeout;

    public FeignClientDefaultConfig(@Value(value="${feign.client.config.default.logger-level:NONE}") Logger.Level loggerLevel, @Value(value="${feign.client.config.default.connect-timeout:3000}") int connectTimeout, @Value(value="${feign.client.config.default.read-timeout:10000}") int readTimeout) {
        this.loggerLevel = loggerLevel;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Bean
    Logger.Level feignLoggerLevel() {
        return this.loggerLevel;
    }

    @Bean
    Request.Options feignRequestOptions() {
        return new Request.Options((long)this.connectTimeout, TimeUnit.MILLISECONDS, (long)this.readTimeout, TimeUnit.MILLISECONDS, true);
    }
}

