/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.config.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
public class OpenApiConfig {
    private static final String BEARER_AUTH = "bearerAuth";
    private static final String DEFAULT_PREFIX_DESCRIPTION = "OpenApi documentation for the ";
    private static final String DEFAULT_VERSION = "1.0";
    private static final Pattern VERSION_PATTERN = Pattern.compile("v(\\d+)");
    private static final Pattern PATH_PATTERN = Pattern.compile("/v(\\d+)(.*)");
    @Value(value="${openapi-config.title}")
    private String title;
    @Value(value="${openapi-config.description:#{null}}")
    private String description;
    @Value(value="${openapi-config.servers}")
    private List<String> servers;
    @Value(value="${openapi-config.security.enabled:false}")
    private boolean securityEnabled;
    @Value(value="${openapi-config.custom-path-processing.enabled:true}")
    private boolean customPathProcessingEnabled;
    private final ApiGroupsProperties apiGroupsProperties;

    public OpenApiConfig(ApiGroupsProperties apiGroupsProperties) {
        this.apiGroupsProperties = apiGroupsProperties;
    }

    @Bean
    OpenAPI openAPI() {
        Info info = new Info().title(this.title).description((String)StringUtils.defaultIfBlank((CharSequence)this.description, (CharSequence)(DEFAULT_PREFIX_DESCRIPTION + this.title))).version(DEFAULT_VERSION).license(new License().name("European Union Public License (EUPL) 1.2").url("https://interoperable-europe.ec.europa.eu/sites/default/files/custom-page/attachment/eupl_v1.2_en.pdf")).contact(new Contact().name("Simpl Programme").url("https://simpl-programme.ec.europa.eu/").email("cnect-simpl@ec.europa.eu"));
        OpenAPI openAPI = new OpenAPI().info(info);
        if (this.securityEnabled) {
            SecurityRequirement securityRequirement = new SecurityRequirement().addList(BEARER_AUTH);
            SecurityScheme securityScheme = new SecurityScheme().name(BEARER_AUTH).description("IAA cloud gateway JWT token").scheme("bearer").type(SecurityScheme.Type.HTTP).bearerFormat("JWT").in(SecurityScheme.In.HEADER);
            openAPI.addSecurityItem(securityRequirement).schemaRequirement(BEARER_AUTH, securityScheme);
        }
        return openAPI;
    }

    private OperationCustomizer createPathPrefixRemover() {
        return (operation, handlerMethod) -> {
            if (!this.customPathProcessingEnabled) {
                return operation;
            }
            operation.setServers(null);
            return operation;
        };
    }

    @Bean
    List<GroupedOpenApi> configuredApiGroups() {
        ArrayList<GroupedOpenApi> groups = new ArrayList<GroupedOpenApi>();
        if (this.apiGroupsProperties == null || this.apiGroupsProperties.getGroups() == null) {
            return groups;
        }
        for (ApiGroupConfig groupConfig : this.apiGroupsProperties.getGroups()) {
            if (!StringUtils.isNotBlank((CharSequence)groupConfig.getName()) || !StringUtils.isNotBlank((CharSequence)groupConfig.getPackagesToScan())) continue;
            GroupedOpenApi.Builder builder = GroupedOpenApi.builder().group(groupConfig.getName()).displayName((String)StringUtils.defaultIfBlank((CharSequence)groupConfig.getDisplayName(), (CharSequence)groupConfig.getName())).packagesToScan(groupConfig.getPackagesToScan().split(","));
            String versionSuffix = this.extractVersionSuffix(groupConfig.getName());
            List<Server> groupServers = this.createGroupServers(versionSuffix);
            builder.addOpenApiCustomizer(openApi -> {
                openApi.setServers(groupServers);
                if (this.customPathProcessingEnabled) {
                    this.processPathsForVersionPrefix(openApi.getPaths());
                }
            });
            builder.addOperationCustomizer(this.createPathPrefixRemover());
            groups.add(builder.build());
        }
        return groups;
    }

    private List<Server> createGroupServers(String versionSuffix) {
        List<Server> groupServers;
        if (this.customPathProcessingEnabled && StringUtils.isNotBlank((CharSequence)versionSuffix)) {
            String apiSuffix = versionSuffix;
            groupServers = this.servers.stream().map(url -> {
                if (!url.endsWith(apiSuffix) && !url.contains(apiSuffix + "/")) {
                    return new Server().url(url + apiSuffix);
                }
                return new Server().url(url);
            }).toList();
        } else {
            groupServers = this.servers.stream().map(url -> new Server().url(url)).toList();
        }
        return groupServers;
    }

    private void processPathsForVersionPrefix(Paths paths) {
        if (paths == null) {
            return;
        }
        LinkedHashMap<String, PathItem> pathsCopy = new LinkedHashMap<String, PathItem>((Map<String, PathItem>)paths);
        pathsCopy.forEach((path, pathItem) -> {
            Matcher matcher;
            if (path.startsWith("/v") && (matcher = PATH_PATTERN.matcher((CharSequence)path)).matches()) {
                Object remainingPath = matcher.group(2);
                if (((String)remainingPath).isEmpty()) {
                    remainingPath = "/";
                }
                if (!((String)remainingPath).startsWith("/")) {
                    remainingPath = "/" + (String)remainingPath;
                }
                paths.addPathItem((String)remainingPath, pathItem);
                paths.remove(path);
            }
        });
    }

    private String extractVersionSuffix(String groupName) {
        if (StringUtils.isBlank((CharSequence)groupName)) {
            return "";
        }
        Matcher matcher = VERSION_PATTERN.matcher(groupName);
        if (matcher.find()) {
            return "/" + matcher.group(0);
        }
        return "";
    }

    @Component
    @ConfigurationProperties(prefix="openapi-config")
    public static class ApiGroupsProperties {
        private List<ApiGroupConfig> groups;

        @Generated
        public List<ApiGroupConfig> getGroups() {
            return this.groups;
        }

        @Generated
        public void setGroups(List<ApiGroupConfig> groups) {
            this.groups = groups;
        }
    }

    public static class ApiGroupConfig {
        private String name;
        private String displayName;
        private String packagesToScan;

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getPackagesToScan() {
            return this.packagesToScan;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setPackagesToScan(String packagesToScan) {
            this.packagesToScan = packagesToScan;
        }
    }
}

