/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.controller;

import eu.europa.ec.simpl.data1.common.enumeration.ErrorType;
import eu.europa.ec.simpl.data1.common.exception.BadRequestException;
import eu.europa.ec.simpl.data1.common.exception.CustomException;
import eu.europa.ec.simpl.data1.common.exception.InvalidSDJsonException;
import eu.europa.ec.simpl.data1.common.exception.UnauthorizedException;
import eu.europa.ec.simpl.data1.common.json.JsonDeserializerException;
import eu.europa.ec.simpl.data1.common.logging.LogRequest;
import eu.europa.ec.simpl.data1.common.model.response.problem.BadRequestProblem;
import eu.europa.ec.simpl.data1.common.model.response.problem.InternalServerErrorProblem;
import eu.europa.ec.simpl.data1.common.model.response.problem.UnauthorizedProblem;
import eu.europa.ec.simpl.data1.common.util.ExceptionUtil;
import eu.europa.ec.simpl.data1.common.util.RestUtil;
import io.github.belgif.rest.problem.api.InputValidationIssue;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

public abstract class AbstractController {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractController.class);
    public static final String CODE_BAD_REQUEST = "400";
    public static final String CODE_UNAUTHORIZED = "401";
    public static final String CODE_NOT_FOUND = "404";
    public static final String CODE_INTERNAL_SERVER_ERROR = "500";
    public static final String CODE_SERVICE_UNAVAILABLE = "503";

    protected AbstractController() {
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=BadRequestProblem.class), examples={@ExampleObject(name="Bad Request Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:validationError\",\n    \"title\": \"Parameter value type invalid\",\n    \"status\": 400,\n    \"detail\": \"date has invalid format\",\n    \"issues\": [\n        {\n            \"detail\": \"fromDate\"\n        }\n    ]\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.BAD_REQUEST)
    public BadRequestProblem methodArgumentTypeMismatchException(HttpServletRequest request, MethodArgumentTypeMismatchException e) {
        log.error("methodArgumentTypeMismatchException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        return RestUtil.createBadRequestProblem(ErrorType.VALIDATION_ERROR, "Parameter value type invalid", e.getMessage(), e.getName());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=BadRequestProblem.class), examples={@ExampleObject(name="Bad Request Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:validationError\",\n    \"title\": \"Missing request parameter\",\n    \"status\": 400,\n    \"detail\": \"Required request parameter 'parameterName' is not present\",\n    \"issues\": [\n        {\n            \"detail\": \"parameterName\"\n        }\n    ]\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.BAD_REQUEST)
    public BadRequestProblem missingServletRequestParameterException(HttpServletRequest request, MissingServletRequestParameterException e) {
        log.error("missingServletRequestParameterException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        return RestUtil.createBadRequestProblem(ErrorType.VALIDATION_ERROR, "Missing request parameter", e.getMessage(), e.getParameterName());
    }

    @ExceptionHandler(value={MissingServletRequestPartException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=BadRequestProblem.class), examples={@ExampleObject(name="Bad Request Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:validationError\",\n    \"title\": \"Missing request part\",\n    \"status\": 400,\n    \"detail\": \"Required request part 'file' is not present\",\n    \"issues\": [\n        {\n            \"detail\": \"file\"\n        }\n    ]\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.BAD_REQUEST)
    public BadRequestProblem missingServletRequestPartException(HttpServletRequest request, MissingServletRequestPartException e) {
        log.error("missingServletRequestPartException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        return RestUtil.createBadRequestProblem(ErrorType.VALIDATION_ERROR, "Missing request part", e.getMessage(), e.getRequestPartName());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=BadRequestProblem.class), examples={@ExampleObject(name="Bad Request Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:validationError\",\n    \"title\": \"Invalid payload\",\n    \"status\": 400,\n    \"detail\": \"missing required arguments\",\n    \"issues\": [\n        {\n            \"detail\": \"Field 'name' must not be empty\"\n        },\n        {\n            \"detail\": \"Field 'email' must be a valid email address\"\n        }\n    ]\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.BAD_REQUEST)
    public BadRequestProblem methodArgumentNotValidException(HttpServletRequest request, MethodArgumentNotValidException e) {
        log.error("methodArgumentNotValidException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        List<InputValidationIssue> issues = e.getFieldErrors().stream().map(fieldError -> new InputValidationIssue().detail(fieldError.getDefaultMessage())).toList();
        return RestUtil.createBadRequestProblem(ErrorType.VALIDATION_ERROR, "Invalid payload", e.getMessage(), issues);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=BadRequestProblem.class), examples={@ExampleObject(name="Bad Request Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:validationError\",\n    \"title\": \"Invalid payload\",\n    \"status\": 400,\n    \"detail\": \"JSON parse error\",\n    \"issues\": [\n        {\n            \"detail\": \"Cannot deserialize value of type `java.time.LocalDate` from String \"invalid-date\"\"\n        }\n    ]\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.BAD_REQUEST)
    public BadRequestProblem methodArgumentNotValidException(HttpServletRequest request, HttpMessageNotReadableException e) {
        log.error("methodArgumentNotValidException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        JsonDeserializerException jsonDeserializerException = ExceptionUtil.findCause((Throwable)e, JsonDeserializerException.class);
        String issueDetail = jsonDeserializerException != null ? jsonDeserializerException.getMessage() : e.getMessage();
        return RestUtil.createBadRequestProblem(ErrorType.VALIDATION_ERROR, "Invalid payload", e.getMessage(), issueDetail);
    }

    @ExceptionHandler(value={CustomException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=BadRequestProblem.class), examples={@ExampleObject(name="Bad Request Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:badRequest\",\n    \"title\": \"Bad Request\",\n    \"status\": 400,\n    \"detail\": \"Error during processing\",\n    \"issues\": [\n        {\n            \"detail\": \"Specific error details\"\n        }\n    ]\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.BAD_REQUEST)
    public BadRequestProblem hashGenerationException(HttpServletRequest request, CustomException e) {
        log.error("hashGenerationException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        return RestUtil.createBadRequestProblem(e.getTypeSuffix(), e.getErrorTitle(), e.getMessage(), null);
    }

    @ExceptionHandler(value={BadRequestException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=BadRequestProblem.class), examples={@ExampleObject(name="Bad Request Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:badRequest\",\n    \"title\": \"Bad Request\",\n    \"status\": 400,\n    \"detail\": \"Missing or invalid argument\",\n    \"issues\": [\n        {\n            \"detail\": \"Specific validation error\"\n        }\n    ]\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.BAD_REQUEST)
    public BadRequestProblem badRequestException(HttpServletRequest request, BadRequestException e) {
        log.error("badRequestException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        return RestUtil.createBadRequestProblem(e.getErrorType(), null, e.getMessage(), (String)null);
    }

    @ExceptionHandler(value={UnauthorizedException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ApiResponse(responseCode="401", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=UnauthorizedProblem.class), examples={@ExampleObject(name="Unauthorized Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:unauthorized\",\n    \"title\": \"Unauthorized\",\n    \"status\": 401,\n    \"detail\": \"Missing or invalid Authorization header\"\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.UNAUTHORIZED)
    public UnauthorizedProblem unauthorizedException(HttpServletRequest request, UnauthorizedException e) {
        log.error("unauthorizedException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        return RestUtil.createUnauthorizedProblem(e.getMessage());
    }

    @ExceptionHandler(value={Throwable.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ApiResponse(responseCode="500", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=InternalServerErrorProblem.class), examples={@ExampleObject(name="Internal Server Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:internalServerError\",\n    \"title\": \"Internal Server Error\",\n    \"status\": 500,\n    \"detail\": \"Unexpected internal error\"\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.INTERNAL_SERVER_ERROR)
    public InternalServerErrorProblem generalException(HttpServletRequest request, Throwable t) {
        log.error("generalException() for request " + String.valueOf(request.getRequestURL()), t);
        return RestUtil.createInternalServerErrorProblem("Unexpected internal error");
    }

    @ExceptionHandler(value={InvalidSDJsonException.class}, produces={"application/problem+json"})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(responseCode="400", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=BadRequestProblem.class), examples={@ExampleObject(name="Bad Request Error Example", value="{\n    \"type\": \"urn:problem-type:simpl:badRequest\",\n    \"title\": \"Bad Request\",\n    \"status\": 400,\n    \"detail\": \"Invalid SD json\",\n    \"issues\": [\n        {\n            \"detail\": \"JSON document validation failed\"\n        }\n    ]\n}\n")})})
    @LogRequest(httpStatus=HttpStatus.BAD_REQUEST)
    public BadRequestProblem invalidSDJsonException(HttpServletRequest request, InvalidSDJsonException e) {
        log.error("invalidSDJsonException() for request " + String.valueOf(request.getRequestURL()), (Throwable)e);
        return RestUtil.createBadRequestProblem(ErrorType.INVALID_DOCUMENT, "Invalid SD json", e.getMessage(), (String)null);
    }
}

