/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.controller.status;

import eu.europa.ec.simpl.data1.common.controller.AbstractController;
import eu.europa.ec.simpl.data1.common.logging.LogRequest;
import eu.europa.ec.simpl.data1.common.model.response.StatusResponse;
import eu.europa.ec.simpl.data1.common.util.PipelineVariablesUtil;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@Hidden
@RestController
@Tag(name="Status Controller")
public class StatusController
extends AbstractController {
    @Generated
    private static final Logger log = LogManager.getLogger(StatusController.class);
    private final HealthEndpoint healthEndpoint;

    @LogRequest
    @Operation(summary="Status information", description="Return a json object with the status information of microservice", responses={@ApiResponse(responseCode="200", description="Successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class), examples={@ExampleObject(value="{\n  \"status\": \"UP\",\n  \"version\": \"1.0.0\"\n}\n")})})})
    @GetMapping(value={"/status"})
    public StatusResponse getStatus() {
        return new StatusResponse(this.healthEndpoint.health().getStatus().getCode(), PipelineVariablesUtil.getProjectVersionNumber());
    }

    @Generated
    public StatusController(HealthEndpoint healthEndpoint) {
        this.healthEndpoint = healthEndpoint;
    }
}

