/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.custom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class CustomMultipartFile
implements MultipartFile {
    private final String name;
    private final String originalFilename;
    private final String contentType;
    private final byte[] content;

    public CustomMultipartFile(String name, String originalFilename, String contentType, byte[] content) {
        this.name = name;
        this.originalFilename = originalFilename;
        this.contentType = contentType;
        this.content = content;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.content == null || this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    public byte[] getBytes() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("transferTo not supported");
    }

    public static MultipartFile convertStringWriterToMultipartFile(String content, String fileName, Charset charset) {
        if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)fileName)) {
            return new CustomMultipartFile("", "", "multipart/form-data", new byte[0]);
        }
        byte[] contentBytes = content.getBytes(charset);
        return new CustomMultipartFile(fileName, fileName, "multipart/form-data", contentBytes);
    }
}

