/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.filter;

import eu.europa.ec.simpl.data1.common.exception.UnauthorizedException;
import eu.europa.ec.simpl.data1.common.service.jwt.JWTService;
import eu.europa.ec.simpl.data1.common.util.AuthBearerUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

@Component
public class BearerTokenFilter
extends HttpFilter {
    @Generated
    private static final Logger log = LogManager.getLogger(BearerTokenFilter.class);
    private static final long serialVersionUID = 1L;
    @Value(value="${web.mvc.bearer-token.required}")
    private boolean bearerTokenRequired;
    @Value(value="${web.mvc.bearer-token.allowed-paths}")
    private List<String> bearerTokenAllowedPaths;
    @Value(value="${springdoc.api-docs.path}")
    private String apiDocsPath;
    @Value(value="${springdoc.swagger-ui.path}")
    private String swaggerUiPath;
    private transient JWTService jwtService;
    private transient AntPathMatcher antPathMatcher;

    public BearerTokenFilter(JWTService jwtService) {
        this.jwtService = jwtService;
        this.antPathMatcher = new AntPathMatcher();
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.bearerTokenRequired && !this.isPathAllowed(request)) {
            String jwtToken = AuthBearerUtil.getBearerValue(request);
            if (jwtToken == null) {
                log.error("doFilter(): no Bearer value found in Authorization header");
                response.setStatus(401);
                response.getWriter().write("Missing or invalid Authorization header");
                return;
            }
            try {
                this.jwtService.checkJWT(jwtToken);
            }
            catch (UnauthorizedException e) {
                log.error("doFilter(): invalid Bearer value found in Authorization header: {}", (Object)e.getMessage());
                response.setStatus(401);
                response.getWriter().write("Invalid Authorization header value");
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isPathAllowed(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        if (requestUri == null) {
            return false;
        }
        return this.isPathAllowed(requestUri) || this.isDocPath(requestUri);
    }

    private boolean isPathAllowed(String requestUri) {
        if (this.bearerTokenAllowedPaths == null || this.bearerTokenAllowedPaths.isEmpty()) {
            return false;
        }
        return this.bearerTokenAllowedPaths.stream().anyMatch(pattern -> this.antPathMatcher.match(pattern, requestUri));
    }

    private boolean isDocPath(String requestUri) {
        return requestUri.startsWith(this.swaggerUiPath) || requestUri.startsWith(this.apiDocsPath);
    }
}

