/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import eu.europa.ec.simpl.data1.common.json.JsonDeserializerSupport;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ISO8601DateJsonDeserializer
extends JsonDeserializerSupport<Date> {
    public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String dateAsString = parser.getText();
        if (StringUtils.isBlank((CharSequence)dateAsString)) {
            return null;
        }
        try {
            Instant instant = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd'T'HH:mm:ss[Z][z]").toFormatter().withZone(ZoneId.of("UTC")).parse((CharSequence)dateAsString, Instant::from);
            return Date.from(instant);
        }
        catch (DateTimeParseException e) {
            throw this.newUnparsableDateTimeException(parser, e);
        }
    }
}

