/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import eu.europa.ec.simpl.data1.common.json.JsonDeserializerSupport;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class ISO8601LocalDateJsonDeserializer
extends JsonDeserializerSupport<Date> {
    public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String dateAsString = parser.getText();
        if (StringUtils.isBlank((CharSequence)dateAsString)) {
            return null;
        }
        try {
            LocalDateTime datetime = LocalDateTime.parse(dateAsString, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            Instant instant = ZonedDateTime.of(datetime, TimeZone.getDefault().toZoneId()).toInstant();
            return Date.from(instant);
        }
        catch (DateTimeParseException e) {
            throw this.newUnparsableDateTimeException(parser, e);
        }
    }
}

