/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class ISO8601LocalDateJsonSerializer
extends JsonSerializer<Date> {
    public void serialize(Date value, JsonGenerator generator, SerializerProvider serializer) throws IOException {
        if (value != null) {
            ZonedDateTime datetime = ZonedDateTime.of(LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault()), ZoneId.systemDefault());
            String dateAsString = datetime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            generator.writeString(dateAsString);
        } else {
            generator.writeNull();
        }
    }
}

