/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import eu.europa.ec.simpl.data1.common.json.JsonDeserializerSupport;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ISO8601OffsetDateJsonDeserializer
extends JsonDeserializerSupport<Date> {
    public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String dateAsString = parser.getText();
        if (StringUtils.isBlank((CharSequence)dateAsString)) {
            return null;
        }
        try {
            ZonedDateTime datetime = ZonedDateTime.parse(dateAsString, DateTimeFormatter.ISO_DATE_TIME);
            return Date.from(datetime.toInstant());
        }
        catch (DateTimeParseException e) {
            throw this.newUnparsableDateTimeException(parser, e);
        }
    }
}

