/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.logging;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;

class CachedBodyHttpServletRequest
extends HttpServletRequestWrapper {
    private static final int DEFAULT_CONTENT_LEN = 1024;
    private static final Charset DEFAULT_CHARACTER_ENCODING = StandardCharsets.ISO_8859_1;
    private final ByteArrayOutputStream cachedContent;
    @Nullable
    private final Integer contentCacheLimit;
    @Nullable
    private ServletInputStream inputStream;
    @Nullable
    private BufferedReader reader;

    public CachedBodyHttpServletRequest(HttpServletRequest request) {
        super(request);
        int contentLength = request.getContentLength();
        this.cachedContent = contentLength >= 0 ? new ByteArrayOutputStream(contentLength) : new ByteArrayOutputStream(1024);
        this.contentCacheLimit = null;
    }

    public CachedBodyHttpServletRequest(HttpServletRequest request, int contentCacheLimit) {
        super(request);
        this.cachedContent = new ByteArrayOutputStream(contentCacheLimit);
        this.contentCacheLimit = contentCacheLimit;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new ContentCachingInputStream(this.getRequest().getInputStream());
        }
        return this.inputStream;
    }

    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        return (String)StringUtils.defaultIfBlank((CharSequence)enc, (CharSequence)"ISO-8859-1");
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
        return this.reader;
    }

    public String getParameter(String name) {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
        return super.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (this.cachedContent.size() == 0 && this.isFormPost()) {
            this.writeRequestParametersToCachedContent();
        }
        return super.getParameterValues(name);
    }

    private boolean isFormPost() {
        String contentType = this.getContentType();
        return contentType != null && contentType.contains("application/x-www-form-urlencoded") && HttpMethod.POST.matches(this.getMethod());
    }

    private void writeRequestParametersToCachedContent() {
        if (this.cachedContent == null || this.cachedContent.size() > 0) {
            return;
        }
        try {
            String requestEncoding = this.getCharacterEncoding();
            Map form = super.getParameterMap();
            boolean first = true;
            for (Map.Entry entry : form.entrySet()) {
                String name = (String)entry.getKey();
                for (String value : (String[])entry.getValue()) {
                    if (!first) {
                        this.cachedContent.write(38);
                    }
                    this.cachedContent.write(URLEncoder.encode(name, requestEncoding).getBytes(DEFAULT_CHARACTER_ENCODING));
                    this.cachedContent.write(61);
                    if (value != null) {
                        this.cachedContent.write(URLEncoder.encode(value, requestEncoding).getBytes(DEFAULT_CHARACTER_ENCODING));
                    }
                    first = false;
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write request parameters to cached content", ex);
        }
    }

    public byte[] getContentAsByteArray() {
        return this.cachedContent.toByteArray();
    }

    protected void handleContentOverflow(int contentCacheLimit) {
    }

    private class ContentCachingInputStream
    extends ServletInputStream {
        private final ServletInputStream is;
        private boolean overflow;

        public ContentCachingInputStream(ServletInputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            int ch = this.is.read();
            if (ch != -1 && !this.overflow) {
                if (CachedBodyHttpServletRequest.this.contentCacheLimit != null && CachedBodyHttpServletRequest.this.cachedContent.size() == CachedBodyHttpServletRequest.this.contentCacheLimit.intValue()) {
                    this.overflow = true;
                    CachedBodyHttpServletRequest.this.handleContentOverflow(CachedBodyHttpServletRequest.this.contentCacheLimit);
                } else {
                    CachedBodyHttpServletRequest.this.cachedContent.write(ch);
                }
            }
            return ch;
        }

        public int read(byte[] b) throws IOException {
            int count = this.is.read(b);
            this.writeToCache(b, 0, count);
            return count;
        }

        private void writeToCache(byte[] b, int off, int count) {
            if (!this.overflow && count > 0) {
                if (CachedBodyHttpServletRequest.this.contentCacheLimit != null && count + CachedBodyHttpServletRequest.this.cachedContent.size() > CachedBodyHttpServletRequest.this.contentCacheLimit) {
                    this.overflow = true;
                    CachedBodyHttpServletRequest.this.cachedContent.write(b, off, CachedBodyHttpServletRequest.this.contentCacheLimit - CachedBodyHttpServletRequest.this.cachedContent.size());
                    CachedBodyHttpServletRequest.this.handleContentOverflow(CachedBodyHttpServletRequest.this.contentCacheLimit);
                    return;
                }
                CachedBodyHttpServletRequest.this.cachedContent.write(b, off, count);
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int count = this.is.read(b, off, len);
            this.writeToCache(b, off, count);
            return count;
        }

        public int readLine(byte[] b, int off, int len) throws IOException {
            int count = this.is.readLine(b, off, len);
            this.writeToCache(b, off, count);
            return count;
        }

        public boolean isFinished() {
            return this.is.isFinished();
        }

        public boolean isReady() {
            return this.is.isReady();
        }

        public void setReadListener(ReadListener readListener) {
            this.is.setReadListener(readListener);
        }
    }
}

