/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.logging;

import eu.europa.ec.simpl.data1.common.logging.LogRequest;
import eu.simpl.MessageBuilder;
import eu.simpl.types.HttpLogMessage;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LoggingAspect {
    private final ThreadLocal<Long> startTime = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logObject(JoinPoint joinPoint, LogRequest logRequest, Throwable ex) {
        Class<?> targetClass = joinPoint.getTarget().getClass();
        Logger logger = LogManager.getLogger(targetClass);
        try {
            if (ex != null) {
                logger.error(ex.getMessage());
            } else {
                if (RequestContextHolder.getRequestAttributes() == null) {
                    return;
                }
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - this.startTime.get();
                HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
                HttpServletResponse httpResponse = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getResponse();
                logger.debug("logObject(): response {}", (Object)httpResponse);
                Integer requestSize = (Integer)request.getAttribute("requestSize");
                MethodSignature ms = (MethodSignature)joinPoint.getSignature();
                logger.debug("logObject(): signature {}", (Object)ms);
                Object httpRequestSize = requestSize != null && requestSize != -1 ? requestSize + " bytes" : "N/A";
                String user = "ANONYMOUS";
                String msg = "HTTP request [" + request.getMethod() + "] " + String.valueOf(request.getRequestURL());
                if (logRequest.httpStatus() == HttpStatus.OK) {
                    logger.info((Message)MessageBuilder.buildMessage((Object)HttpLogMessage.builder().msg(msg).httpStatus(String.valueOf(logRequest.httpStatus().value())).httpRequestSize((String)httpRequestSize).httpExecutionTime(elapsedTime + " ms").user(user).build()));
                } else {
                    logger.error((Message)MessageBuilder.buildMessage((Object)HttpLogMessage.builder().msg(msg).httpStatus(String.valueOf(logRequest.httpStatus().value())).httpRequestSize((String)httpRequestSize).httpExecutionTime(elapsedTime + " ms").user(user).build()));
                }
            }
        }
        catch (Exception e) {
            logger.error("logObject() failed cause {}", (Object)e.toString());
        }
        finally {
            this.startTime.remove();
        }
    }

    @Around(value="@annotation(logRequest)")
    public Object trace(ProceedingJoinPoint pjp, LogRequest logRequest) throws Throwable {
        this.startTime.set(System.currentTimeMillis());
        Object returnValue = pjp.proceed();
        this.logObject((JoinPoint)pjp, logRequest, null);
        return returnValue;
    }

    @AfterThrowing(pointcut="@annotation(logRequest)", throwing="ex")
    public void logException(JoinPoint joinPoint, LogRequest logRequest, Throwable ex) {
        this.logObject(joinPoint, logRequest, ex);
    }
}

