/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.util;

import com.auth0.jwt.JWT;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public final class AuthBearerUtil {
    public static final String BEARER_PREFIX = "Bearer";

    private AuthBearerUtil() {
    }

    public static String getBearerValue(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ")) {
            return authorizationHeader.replace("Bearer ", "");
        }
        return null;
    }

    public static String toBearerString(String bearerToken) {
        return "Bearer " + bearerToken;
    }

    public static JSONObject getJwtTokenPayloadAsJsonObject(HttpServletRequest request) {
        String payload = AuthBearerUtil.getJwtTokenPayload(request);
        if (StringUtils.isNotBlank((CharSequence)payload)) {
            return new JSONObject(payload);
        }
        return null;
    }

    public static String getJwtTokenPayload(HttpServletRequest request) {
        String jwtToken = AuthBearerUtil.getBearerValue(request);
        if (StringUtils.isNotBlank((CharSequence)jwtToken)) {
            return new String(Base64.decodeBase64((String)JWT.decode((String)jwtToken).getPayload()), StandardCharsets.UTF_8);
        }
        return null;
    }

    public static String getCredentialId(HttpServletRequest request) {
        JSONObject payload = AuthBearerUtil.getJwtTokenPayloadAsJsonObject(request);
        if (payload != null) {
            return payload.optString("credential_id", null);
        }
        return null;
    }
}

