/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Date;

public final class DateTimeUtil {
    private static final String GMT_ZONE_ID = "GMT";
    private static final String UTC_ZONE_ID = "UTC";

    private DateTimeUtil() {
    }

    public static String dateTimeToString(Date dateTime, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.of(GMT_ZONE_ID);
        }
        ZonedDateTime zoneDateTime = ZonedDateTime.of(LocalDateTime.ofInstant(dateTime.toInstant(), zoneId), zoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        return zoneDateTime.format(formatter);
    }

    public static Date dateTimeFromString(String dateTimeAsString) {
        Instant instant = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd'T'HH:mm:ss[Z][z]").toFormatter().withZone(ZoneId.of(UTC_ZONE_ID)).parse((CharSequence)dateTimeAsString, Instant::from);
        return Date.from(instant);
    }
}

