/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.util;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europa.ec.simpl.data1.common.exception.InvalidSDJsonException;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static JSONObject createJSONObject(String sdJsonLd) throws InvalidSDJsonException {
        try {
            return new JSONObject(sdJsonLd);
        }
        catch (JSONException e) {
            throw new InvalidSDJsonException(e.getMessage(), e);
        }
    }

    public static JsonNode createJsonNode(String jsonLd, ObjectMapper objectMapper) throws InvalidSDJsonException {
        try {
            return objectMapper.readTree(jsonLd);
        }
        catch (JacksonException e) {
            throw new InvalidSDJsonException(e.getMessage(), e);
        }
    }
}

