/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PipelineVariablesUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(PipelineVariablesUtil.class);
    private static final String PATH_PIPELINE_VARIABLES_FILE = "./pipeline.variables.sh";
    private static final String PROJECT_VERSION_NUMBER = "PROJECT_VERSION_NUMBER";
    private static final int EXPECTED_PARTS_LENGTH = 2;

    private PipelineVariablesUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getProjectVersionNumber() {
        Map<String, String> variables = PipelineVariablesUtil.readVariables();
        String versionValue = variables.get(PROJECT_VERSION_NUMBER);
        if (versionValue != null) {
            log.debug("Variable version found {}={}", (Object)PROJECT_VERSION_NUMBER, (Object)versionValue);
            return versionValue;
        }
        String error = "Version file not found or unreadable";
        log.error(error);
        return error;
    }

    private static Map<String, String> readVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        try (Stream<String> lines = Files.lines(Paths.get(PATH_PIPELINE_VARIABLES_FILE, new String[0]));){
            lines.filter(line -> line.contains("=")).forEach(line -> {
                String[] parts = line.replace("\"", "").split("=");
                if (parts.length == 2) {
                    variables.put(parts[0].trim(), parts[1].trim());
                }
            });
        }
        catch (IOException e) {
            log.error("Error reading file: {} {}", (Object)PATH_PIPELINE_VARIABLES_FILE, (Object)e.getMessage());
        }
        return variables;
    }
}

