/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.simpl.data1.common.util;

import eu.europa.ec.simpl.data1.common.enumeration.ErrorType;
import eu.europa.ec.simpl.data1.common.model.response.problem.BadRequestProblem;
import eu.europa.ec.simpl.data1.common.model.response.problem.InternalServerErrorProblem;
import eu.europa.ec.simpl.data1.common.model.response.problem.NotFoundProblem;
import eu.europa.ec.simpl.data1.common.model.response.problem.ServiceUnavailableProblem;
import eu.europa.ec.simpl.data1.common.model.response.problem.UnauthorizedProblem;
import io.github.belgif.rest.problem.api.InputValidationIssue;
import io.github.belgif.rest.problem.api.Problem;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public final class RestUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(RestUtil.class);

    private RestUtil() {
    }

    public static <T extends Problem> ResponseEntity<T> toResponseEntity(T problem) {
        return ResponseEntity.status((int)problem.getStatus()).contentType(MediaType.APPLICATION_PROBLEM_JSON).body(problem);
    }

    public static BadRequestProblem createBadRequestProblem(ErrorType errorType, String title, String detail, String issueDetail) {
        return RestUtil.createBadRequestProblem(errorType.toErrorTypeSuffix(), title, detail, issueDetail);
    }

    public static BadRequestProblem createBadRequestProblem(String typeSuffix, String title, String detail, String issueDetail) {
        InputValidationIssue issue = null;
        if (StringUtils.isNotBlank((CharSequence)issueDetail)) {
            issue = new InputValidationIssue().detail(issueDetail);
        }
        return new BadRequestProblem(typeSuffix, title, detail, issue);
    }

    public static BadRequestProblem createBadRequestProblem(ErrorType errorType, String title, String detail, List<InputValidationIssue> issues) {
        BadRequestProblem result = new BadRequestProblem(errorType.toErrorTypeSuffix(), title, detail, null);
        result.setIssues(issues);
        return result;
    }

    public static NotFoundProblem createNotFoundProblem(ErrorType errorType, String title, String detail) {
        return RestUtil.createNotFoundProblem(errorType.toErrorTypeSuffix(), title, detail);
    }

    public static NotFoundProblem createNotFoundProblem(String typeSuffix, String title, String detail) {
        return new NotFoundProblem(typeSuffix, title, detail);
    }

    public static ServiceUnavailableProblem createServiceUnavailableProblem(ErrorType errorType, String title, String detail) {
        return RestUtil.createServiceUnavailableProblem(errorType.toErrorTypeSuffix(), title, detail);
    }

    public static ServiceUnavailableProblem createServiceUnavailableProblem(String typeSuffix, String title, String detail) {
        return new ServiceUnavailableProblem(typeSuffix, title, detail);
    }

    public static UnauthorizedProblem createUnauthorizedProblem(String detail) {
        return new UnauthorizedProblem(detail);
    }

    public static InternalServerErrorProblem createInternalServerErrorProblem(String detail) {
        return new InternalServerErrorProblem(detail);
    }
}

